/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class DateField
extends Item {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    public Date date;
    public Date time;
    String label;
    int mode;
    ChoiceGroup dateTime;
    public i dateCanvas;
    public z timeCanvas;
    public static Command saveCommand = new Command("Save", 4, 0);
    public static Command backCommand = new Command("Back", 2, 0);
    CommandListener dateTimeListener = new j(this);

    public DateField(String string, int n2) {
        this(string, n2, null);
    }

    public DateField(String string, int n2, TimeZone timeZone) {
        super(null);
        this.label = string;
        this.setInputMode(n2);
        this.dateCanvas = new i();
        this.dateCanvas.addCommand(saveCommand);
        this.dateCanvas.addCommand(backCommand);
        this.dateCanvas.setCommandListener(this.dateTimeListener);
        this.timeCanvas = new z();
        this.timeCanvas.addCommand(saveCommand);
        this.timeCanvas.addCommand(backCommand);
        this.timeCanvas.setCommandListener(this.dateTimeListener);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.updateDateTimeString();
    }

    public int getInputMode() {
        return this.mode;
    }

    public void setInputMode(int n2) {
        if (n2 <= 0 || n2 > 3) {
            throw new IllegalArgumentException();
        }
        this.mode = n2;
        this.dateTime = new ChoiceGroup(this.label, 3, false);
        if ((n2 & 1) != 0) {
            this.dateTime.append("[date]", null);
        }
        if ((n2 & 2) != 0) {
            this.dateTime.append("[time]", null);
        }
    }

    boolean isFocusable() {
        return true;
    }

    int getHeight() {
        return super.getHeight() + this.dateTime.getHeight();
    }

    int paint(Graphics graphics) {
        super.paintContent(graphics);
        graphics.translate(0, super.getHeight());
        this.dateTime.paint(graphics);
        graphics.translate(0, -super.getHeight());
        return this.getHeight();
    }

    void setFocus(boolean bl2) {
        super.setFocus(bl2);
        this.dateTime.setFocus(bl2);
    }

    boolean select() {
        this.dateTime.select();
        if (this.dateTime.getSelectedIndex() == 0 && (this.mode & 1) != 0) {
            if (this.date != null) {
                this.dateCanvas.a(this.date);
            } else {
                this.dateCanvas.a(new Date());
            }
            this.getOwner().currentDisplay.setCurrent(this.dateCanvas);
        } else {
            if (this.time != null) {
                this.timeCanvas.a(this.time);
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, 1970);
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(11, 12);
                calendar.set(12, 0);
                calendar.set(13, 0);
                this.timeCanvas.a(calendar.getTime());
            }
            this.getOwner().currentDisplay.setCurrent(this.timeCanvas);
        }
        return true;
    }

    int traverse(int n2, int n3, int n4, boolean bl2) {
        return this.dateTime.traverse(n2, n3, n4, bl2);
    }

    private String formatDate() {
        if (this.date == null) {
            return "[date]";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        int n2 = calendar.get(5);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(1);
        return Integer.toString(n2) + "-" + n3 + "-" + n4;
    }

    private String formatTime() {
        if (this.time == null) {
            return "[time]";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.time);
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        return Integer.toString(n2) + ":" + (n3 < 10 ? "0" : "") + n3;
    }

    public void updateDateTimeString() {
        if ((this.mode & 1) != 0) {
            this.dateTime.set(0, this.formatDate(), null);
        }
        if ((this.mode & 2) != 0) {
            this.dateTime.set((this.mode & 1) != 0 ? 1 : 0, this.formatTime(), null);
        }
    }
}

