/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import org.microemu.device.DeviceFactory;
import org.microemu.device.ui.FormUI;

public class Form
extends Screen {
    public Item[] items = new Item[4];
    int numOfItems = 0;
    int focusItemIndex;
    ItemStateListener itemStateListener = null;

    public Form(String string) {
        super(string);
        super.setUI(DeviceFactory.getDevice().getUIFactory().createFormUI(this));
        this.focusItemIndex = -2;
    }

    public Form(String string, Item[] itemArray) {
        this(string);
        if (itemArray != null) {
            this.items = new Item[itemArray.length];
            System.arraycopy(itemArray, 0, this.items, 0, itemArray.length);
            this.numOfItems = this.items.length;
            for (int i2 = 0; i2 < this.numOfItems; ++i2) {
                Form form = this;
                form.verifyItem(form.items[i2]);
            }
        }
    }

    public int append(Item item) {
        this.verifyItem(item);
        if (this.ui.getClass().getName().equals("org.microemu.android.device.ui.AndroidFormUI")) {
            ((FormUI)this.ui).append(item);
        }
        if (this.numOfItems + 1 >= this.items.length) {
            Item[] itemArray = new Item[this.numOfItems + 4];
            System.arraycopy(this.items, 0, itemArray, 0, this.numOfItems);
            this.items = itemArray;
        }
        this.items[this.numOfItems] = item;
        ++this.numOfItems;
        this.repaint();
        return this.numOfItems - 1;
    }

    public int append(Image image) {
        if (this.ui.getClass().getName().equals("org.microemu.android.device.ui.AndroidFormUI")) {
            ((FormUI)this.ui).append(new ImageItem(null, image, 0, null));
        }
        return this.append(new ImageItem(null, image, 0, null));
    }

    public int append(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.ui.getClass().getName().equals("org.microemu.android.device.ui.AndroidFormUI")) {
            ((FormUI)this.ui).append(new StringItem(null, string));
        }
        return this.append(new StringItem(null, string));
    }

    public void delete(int n2) {
        this.verifyItemNum(n2);
        if (this.ui.getClass().getName().equals("org.microemu.android.device.ui.AndroidFormUI")) {
            ((FormUI)this.ui).delete(n2);
        }
        this.items[n2].setOwner(null);
        System.arraycopy(this.items, n2 + 1, this.items, n2, this.numOfItems - n2 - 1);
        --this.numOfItems;
        this.repaint();
    }

    public void deleteAll() {
        if (this.ui.getClass().getName().equals("org.microemu.android.device.ui.AndroidFormUI")) {
            ((FormUI)this.ui).deleteAll();
        }
        for (int i2 = 0; i2 < this.numOfItems; ++i2) {
            this.items[i2].setOwner(null);
        }
        this.numOfItems = 0;
        this.repaint();
    }

    public Item get(int n2) {
        this.verifyItemNum(n2);
        return this.items[n2];
    }

    public int getHeight() {
        return super.getHeight();
    }

    public int getWidth() {
        return super.getWidth();
    }

    public void insert(int n2, Item item) {
        if (n2 != this.numOfItems) {
            this.verifyItemNum(n2);
        }
        this.verifyItem(item);
        if (this.ui.getClass().getName().equals("org.microemu.android.device.ui.AndroidFormUI")) {
            ((FormUI)this.ui).insert(n2, item);
        }
        if (this.numOfItems + 1 == this.items.length) {
            Item[] itemArray = new Item[this.numOfItems + 4];
            System.arraycopy(this.items, 0, itemArray, 0, this.numOfItems);
            this.items = itemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.numOfItems - n2);
        this.items[n2] = item;
        this.items[n2].setOwner(this);
        ++this.numOfItems;
        this.repaint();
    }

    public void set(int n2, Item item) {
        this.verifyItemNum(n2);
        this.verifyItem(item);
        if (this.ui.getClass().getName().equals("org.microemu.android.device.ui.AndroidFormUI")) {
            ((FormUI)this.ui).set(n2, item);
        }
        this.items[n2].setOwner(null);
        this.items[n2] = item;
        this.items[n2].setOwner(this);
        this.repaint();
    }

    public void setItemStateListener(ItemStateListener itemStateListener) {
        this.itemStateListener = itemStateListener;
    }

    public int size() {
        return this.numOfItems;
    }

    int paintContent(Graphics graphics) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.numOfItems; ++i2) {
            int n3 = this.items[i2].paint(graphics);
            graphics.translate(0, n3);
            n2 += n3;
        }
        graphics.translate(0, -n2);
        return n2;
    }

    void fireItemStateListener(Item item) {
        if (this.itemStateListener != null) {
            this.itemStateListener.itemStateChanged(item);
        }
    }

    public void fireItemStateListener() {
        if (this.focusItemIndex >= 0 && this.focusItemIndex < this.items.length) {
            Form form = this;
            form.fireItemStateListener(form.items[this.focusItemIndex]);
        }
    }

    void hideNotify() {
        super.hideNotify();
        for (int i2 = 0; i2 < this.numOfItems; ++i2) {
            if (!this.items[i2].isFocusable() || !this.items[i2].hasFocus()) continue;
            this.items[i2].setFocus(false);
            this.focusItemIndex = -2;
            return;
        }
    }

    void keyPressed(int n2) {
        if (this.focusItemIndex != -1) {
            if (Display.getGameAction(n2) == 8) {
                this.items[this.focusItemIndex].select();
                this.fireItemStateListener();
            } else {
                this.items[this.focusItemIndex].keyPressed(n2);
            }
        }
        super.keyPressed(n2);
    }

    void showNotify() {
        int n2;
        super.showNotify();
        if (this.focusItemIndex == -2) {
            this.focusItemIndex = -1;
            for (n2 = 0; n2 < this.numOfItems; ++n2) {
                if (!this.items[n2].isFocusable()) continue;
                this.items[n2].setFocus(true);
                this.focusItemIndex = n2;
                break;
            }
        }
        if (this.focusItemIndex < 0) {
            return;
        }
        Form form = this;
        n2 = form.getHeightToItem(form.focusItemIndex);
        int n3 = n2 + this.items[this.focusItemIndex].getHeight();
        if (this.viewPortY > n2) {
            this.viewPortY = n2;
            return;
        }
        if (this.viewPortY + this.viewPortHeight < n3) {
            this.viewPortY = n3 - this.viewPortHeight;
        }
    }

    int traverse(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (this.numOfItems == 0) {
            return 0;
        }
        if (n2 == 1) {
            n7 = this.getTopVisibleIndex(n3);
            if (this.focusItemIndex == -1) {
                n6 = n7;
                n5 = this.getHeightToItem(n6);
                n5 = this.items[n6].traverse(n2, n3 - n5, n4 - n5, false);
            } else {
                n6 = this.focusItemIndex;
                n5 = this.getHeightToItem(n6);
                n5 = this.items[n6].traverse(n2, n3 - n5, n4 - n5, true);
            }
            if (n5 != Integer.MAX_VALUE) {
                if (this.focusItemIndex == -1 && this.items[n6].isFocusable()) {
                    this.items[n6].setFocus(true);
                    this.focusItemIndex = n6;
                }
                return n5;
            }
            if (n6 > 0) {
                --n6;
                while (n6 >= n7) {
                    if (this.items[n6].isFocusable()) {
                        if (this.focusItemIndex != -1) {
                            this.items[this.focusItemIndex].setFocus(false);
                        }
                        this.items[n6].setFocus(true);
                        this.focusItemIndex = n6;
                        n5 = this.getHeightToItem(n6);
                        n5 = this.items[n6].traverse(n2, n3 - n5, n4 - n5, false);
                        if (n5 == Integer.MAX_VALUE) {
                            return 0;
                        }
                        return n5;
                    }
                    --n6;
                }
                n5 = this.getHeightToItem(n7);
                if ((n5 = this.items[n7].traverse(n2, n3 - n5, n4 - n5, false)) != Integer.MAX_VALUE) {
                    n7 = this.getTopVisibleIndex(n4 + n5);
                    if (this.focusItemIndex != -1 && this.focusItemIndex > n7) {
                        this.items[this.focusItemIndex].setFocus(false);
                        this.focusItemIndex = -1;
                    }
                    return n5;
                }
            }
        }
        if (n2 == 6) {
            n7 = this.getBottomVisibleIndex(n4);
            if (this.focusItemIndex == -1) {
                n6 = n7;
                n5 = this.getHeightToItem(n6);
                n5 = this.items[n6].traverse(n2, n3 - n5, n4 - n5, false);
            } else {
                n6 = this.focusItemIndex;
                n5 = this.getHeightToItem(n6);
                n5 = this.items[n6].traverse(n2, n3 - n5, n4 - n5, true);
            }
            if (n5 != Integer.MAX_VALUE) {
                if (this.focusItemIndex == -1 && this.items[n6].isFocusable()) {
                    this.items[n6].setFocus(true);
                    this.focusItemIndex = n6;
                }
                return n5;
            }
            if (n6 < this.numOfItems - 1) {
                ++n6;
                while (n6 <= n7) {
                    if (this.items[n6].isFocusable()) {
                        if (this.focusItemIndex != -1) {
                            this.items[this.focusItemIndex].setFocus(false);
                        }
                        this.items[n6].setFocus(true);
                        this.focusItemIndex = n6;
                        n5 = this.getHeightToItem(n6);
                        n5 = this.items[n6].traverse(n2, n3 - n5, n4 - n5, false);
                        if (n5 == Integer.MAX_VALUE) {
                            return 0;
                        }
                        return n5;
                    }
                    ++n6;
                }
                n5 = this.getHeightToItem(n7);
                if ((n5 = this.items[n7].traverse(n2, n3 - n5, n4 - n5, false)) != Integer.MAX_VALUE) {
                    n7 = this.getTopVisibleIndex(n3 + n5);
                    if (this.focusItemIndex != -1 && this.focusItemIndex < n7) {
                        this.items[this.focusItemIndex].setFocus(false);
                        this.focusItemIndex = -1;
                    }
                    return n5;
                }
            }
        }
        return 0;
    }

    private int getTopVisibleIndex(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.numOfItems; ++i2) {
            if ((n3 += this.items[i2].getHeight()) < n2) continue;
            return i2;
        }
        return this.numOfItems - 1;
    }

    private int getBottomVisibleIndex(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.numOfItems; ++i2) {
            if ((n3 += this.items[i2].getHeight()) <= n2) continue;
            return i2;
        }
        return this.numOfItems - 1;
    }

    private int getHeightToItem(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.items[i2].getHeight();
        }
        return n3;
    }

    private void verifyItem(Item item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        if (item.getOwner() != null) {
            throw new IllegalStateException("item is already owned");
        }
        item.setOwner(this);
    }

    private void verifyItemNum(int n2) {
        if (n2 < 0 || n2 >= this.numOfItems) {
            throw new IndexOutOfBoundsException("item number is outside range of Form");
        }
    }

    Vector getCommands() {
        int n2;
        Object object = super.getCommands();
        if (this.focusItemIndex < 0) {
            return object;
        }
        Item item = this.items[this.focusItemIndex];
        Vector vector = item.commands;
        if (vector.isEmpty()) {
            return object;
        }
        Vector<Object> vector2 = new Vector<Object>();
        for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
            vector2.add(((Vector)object).elementAt(n2));
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (Command)vector.elementAt(n2);
            object = ((Command)object).getItemCommand(item);
            vector2.add(object);
        }
        return vector2;
    }
}

