/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import org.microemu.device.DeviceFactory;
import org.microemu.device.InputMethod;
import org.microemu.device.InputMethodListener;

public class TextField
extends Item {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int CONSTRAINT_MASK = 65535;
    w stringComponent;
    private String field;
    private int caret;
    private boolean caretVisible;
    private int maxSize;
    private int constraints;
    private InputMethodListener inputMethodListener = new y(this);

    public TextField(String string, String string2, int n2, int n3) {
        super(string);
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.setConstraints(n3);
        if (!InputMethod.validate(string2, n3)) {
            throw new IllegalArgumentException();
        }
        this.maxSize = n2;
        this.stringComponent = new w();
        if (string2 != null) {
            this.setString(string2);
        } else {
            this.setString("");
        }
        this.stringComponent.c(8);
    }

    public String getString() {
        return this.field;
    }

    public void setString(String string) {
        String string2 = string;
        this.setString(string2, string2.length());
    }

    public void setString(String string, int n2) {
        if (!InputMethod.validate(string, this.constraints)) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            this.field = "";
            this.stringComponent.a("");
        } else {
            if (string.length() > this.maxSize) {
                throw new IllegalArgumentException();
            }
            this.field = string;
            if ((this.constraints & 0x10000) == 0) {
                this.stringComponent.a(string);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    stringBuffer.append('*');
                }
                this.stringComponent.a(stringBuffer.toString());
            }
        }
        this.setCaretPosition(n2);
        this.setCaretVisible(false);
        this.repaint();
    }

    public int getChars(char[] cArray) {
        if (cArray.length < this.field.length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.getString().getChars(0, this.field.length(), cArray, 0);
        return this.field.length();
    }

    public void setChars(char[] object, int n2, int n3) {
        if (object == null) {
            this.setString("");
        } else {
            if (n3 > this.maxSize) {
                throw new IllegalArgumentException();
            }
            String string = new String((char[])object, n2, n3);
            object = string;
            if (!InputMethod.validate(string, this.constraints)) {
                throw new IllegalArgumentException();
            }
            this.setString((String)object);
        }
        this.repaint();
    }

    public void insert(String string, int n2) {
        if (!InputMethod.validate(string, this.constraints)) {
            throw new IllegalArgumentException();
        }
        if (this.field.length() + string.length() > this.maxSize) {
            throw new IllegalArgumentException();
        }
        String string2 = "";
        if (n2 > 0) {
            string2 = this.getString().substring(0, n2);
        }
        string2 = string2 + string;
        if (n2 < this.field.length()) {
            string2 = string2 + this.getString().substring(n2 + 1);
        }
        this.setString(string2);
        this.repaint();
    }

    public void insert(char[] cArray, int n2, int n3, int n4) {
        if (n2 + n3 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.insert(new String(cArray, n2, n3), n4);
    }

    public void delete(int n2, int n3) {
        if (n2 + n3 > this.field.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        String string = "";
        if (n2 > 0) {
            string = this.getString().substring(0, n2);
        }
        if (n2 + n3 < this.field.length()) {
            string = string + this.getString().substring(n2 + n3);
        }
        this.setString(string);
        this.repaint();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int setMaxSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.field.length() > n2) {
            TextField textField = this;
            textField.setString(textField.getString().substring(0, n2));
        }
        this.maxSize = n2;
        return n2;
    }

    public int size() {
        return this.field.length();
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public void setConstraints(int n2) {
        if ((n2 & 0xFFFF) < 0 || (n2 & 0xFFFF) > 5) {
            throw new IllegalArgumentException("constraints " + n2 + " is an illegal value");
        }
        this.constraints = n2;
        if (!InputMethod.validate(this.field, n2)) {
            this.setString("");
        }
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void setInitialInputMode(String string) {
    }

    boolean isFocusable() {
        return true;
    }

    int getHeight() {
        return super.getHeight() + this.stringComponent.b() + 8;
    }

    int paint(Graphics graphics) {
        super.paintContent(graphics);
        graphics.translate(0, super.getHeight());
        int n2 = graphics.getColor();
        if (!this.hasFocus()) {
            graphics.setGrayScale(127);
        }
        graphics.drawRect(1, 1, this.owner.getWidth() - 3, this.stringComponent.b() + 4);
        if (!this.hasFocus()) {
            graphics.setColor(n2);
        }
        graphics.translate(3, 3);
        this.paintContent(graphics);
        graphics.translate(-3, -3);
        graphics.translate(0, -super.getHeight());
        return this.getHeight();
    }

    void paintContent(Graphics graphics) {
        this.stringComponent.a(graphics);
        if (this.caretVisible) {
            int n2 = this.stringComponent.a(this.caret);
            int n3 = this.stringComponent.b(this.caret);
            graphics.drawLine(n2, n3, n2, n3 + Font.getDefaultFont().getHeight());
        }
    }

    public void setCaretPosition(int n2) {
        this.caret = n2;
    }

    public void setCaretVisible(boolean bl2) {
        this.caretVisible = bl2;
    }

    int traverse(int n2, int n3, int n4, boolean bl2) {
        if (n2 == 1) {
            if (n3 > 0) {
                return -n3;
            }
            return Integer.MAX_VALUE;
        }
        if (n2 == 6) {
            if (this.getHeight() > n4) {
                return this.getHeight() - n4;
            }
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    void setFocus(boolean bl2) {
        super.setFocus(bl2);
        if (bl2) {
            InputMethod inputMethod = DeviceFactory.getDevice().getInputMethod();
            inputMethod.setInputMethodListener(this.inputMethodListener);
            inputMethod.setMaxSize(this.getMaxSize());
            this.setCaretVisible(true);
            return;
        }
        DeviceFactory.getDevice().getInputMethod().removeInputMethodListener(this.inputMethodListener);
        this.setCaretVisible(false);
    }
}

