/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import org.microemu.MicroEmulator;
import org.microemu.RecordStoreManager;
import org.microemu.app.Config;
import org.microemu.log.Logger;
import org.microemu.util.ExtendedRecordListener;
import org.microemu.util.RecordStoreImpl;

public class FileRecordStoreManager
implements RecordStoreManager {
    private static final List a = new Vector<String>();
    private MicroEmulator b;
    private Hashtable c = new Hashtable();
    private ExtendedRecordListener d = null;
    private AccessControlContext e;
    private FilenameFilter f = new bc(this);

    public void init(MicroEmulator microEmulator) {
        this.b = microEmulator;
        this.e = AccessController.getContext();
    }

    public String getName() {
        return "File record store";
    }

    public File getSuiteFolder() {
        return new File(Config.getConfigPath(), "suite-" + this.b.getLauncher().getSuiteName());
    }

    private static String a(String string) {
        return "_%%" + string.charAt(0) + "%%_";
    }

    private static String b(String string) {
        Iterator iterator = a.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = FileRecordStoreManager.a(string2);
            if (string2.equals("\\")) {
                string2 = "\\\\";
            }
            string2 = "[" + string2 + "]";
            string = string.replaceAll(string2, string3);
        }
        return string + ".rs";
    }

    public void deleteRecordStore(String string) {
        File file = new File(this.getSuiteFolder(), FileRecordStoreManager.b(string));
        RecordStoreImpl recordStoreImpl = (RecordStoreImpl)this.c.get(file.getName());
        if (recordStoreImpl != null && recordStoreImpl.isOpen()) {
            throw new RecordStoreException();
        }
        try {
            this.a(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RecordStoreNotFoundException(string);
        }
        try {
            AccessController.doPrivileged(new bd(this, file, string), this.e);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Logger.error("Unable remove file " + file, privilegedActionException);
            throw new RecordStoreException();
        }
    }

    public RecordStore openRecordStore(String string, boolean bl2) {
        RecordStoreImpl recordStoreImpl;
        File file = new File(this.getSuiteFolder(), FileRecordStoreManager.b(string));
        try {
            recordStoreImpl = this.a(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!bl2) {
                throw new RecordStoreNotFoundException(string);
            }
            recordStoreImpl = new RecordStoreImpl((RecordStoreManager)this, string);
            this.a(file, recordStoreImpl);
        }
        recordStoreImpl.setOpen(true);
        if (this.d != null) {
            recordStoreImpl.addRecordListener(this.d);
        }
        this.c.put(file.getName(), recordStoreImpl);
        this.fireRecordStoreListener(8, string);
        return recordStoreImpl;
    }

    public String[] listRecordStores() {
        String[] stringArray;
        try {
            stringArray = (String[])AccessController.doPrivileged(new be(this), this.e);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Logger.error("Unable to access storeFiles", privilegedActionException);
            return null;
        }
        if (stringArray != null) {
            if (stringArray.length == 0) {
                stringArray = null;
            } else {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    Iterator iterator = a.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        String string3 = FileRecordStoreManager.a(string2);
                        if (string2.equals("\\")) {
                            string2 = "\\\\";
                        }
                        string = string.replaceAll(string3, string2);
                    }
                    stringArray[i2] = string.substring(0, string.length() - 3);
                }
            }
        }
        return stringArray;
    }

    public void saveChanges(RecordStoreImpl recordStoreImpl) {
        File file = new File(this.getSuiteFolder(), FileRecordStoreManager.b(recordStoreImpl.getName()));
        this.a(file, recordStoreImpl);
    }

    public void init() {
    }

    public void deleteStores() {
        String[] stringArray = this.listRecordStores();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            try {
                this.deleteRecordStore(string);
                continue;
            }
            catch (RecordStoreException recordStoreException) {
                Logger.debug("deleteRecordStore", recordStoreException);
            }
        }
    }

    private RecordStoreImpl a(File file) {
        try {
            return (RecordStoreImpl)AccessController.doPrivileged(new bf(this, file), this.e);
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            if (privilegedActionException.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException2.getCause();
            }
            Logger.error("Unable access file " + file, privilegedActionException2);
            throw new FileNotFoundException();
        }
    }

    private RecordStoreImpl b(File file) {
        RecordStoreImpl recordStoreImpl = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            recordStoreImpl = new RecordStoreImpl((RecordStoreManager)this, dataInputStream);
            dataInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            Logger.error("RecordStore.loadFromDisk: ERROR reading " + file.getName(), iOException);
        }
        return recordStoreImpl;
    }

    private void a(File file, RecordStoreImpl object) {
        try {
            AccessController.doPrivileged(new bg(this, file, (RecordStoreImpl)object), this.e);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            if (privilegedActionException.getCause() instanceof RecordStoreException) {
                throw (RecordStoreException)((Throwable)object).getCause();
            }
            Logger.error("Unable access file " + file, (Throwable)object);
            throw new RecordStoreException();
        }
    }

    public int getSizeAvailable(RecordStoreImpl recordStoreImpl) {
        return 0x100000;
    }

    public void setRecordListener(ExtendedRecordListener extendedRecordListener) {
        this.d = extendedRecordListener;
    }

    public void fireRecordStoreListener(int n2, String string) {
        if (this.d != null) {
            this.d.recordStoreEvent(n2, System.currentTimeMillis(), string);
        }
    }

    public static FilenameFilter a(FileRecordStoreManager fileRecordStoreManager) {
        return fileRecordStoreManager.f;
    }

    public static RecordStoreImpl a(FileRecordStoreManager fileRecordStoreManager, File file) {
        return fileRecordStoreManager.b(file);
    }

    public static void a(FileRecordStoreManager object, File object2, RecordStoreImpl object3) {
        File file = object2;
        object2 = object3;
        object = file;
        if (!file.getParentFile().exists() && !((File)object).getParentFile().mkdirs()) {
            throw new RecordStoreException("Unable to create recordStore directory");
        }
        try {
            object3 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)object)));
            ((RecordStoreImpl)object2).write((DataOutputStream)object3);
            ((FilterOutputStream)object3).close();
            return;
        }
        catch (IOException iOException) {
            Logger.error("RecordStore.saveToDisk: ERROR writting object to " + ((File)object).getName(), iOException);
            throw new RecordStoreException(iOException.getMessage());
        }
    }

    static {
        a.add(":");
        a.add("*");
        a.add("?");
        a.add("=");
        a.add("|");
        a.add("/");
        a.add("\\");
        a.add("\"");
    }
}

